#Opmærkning af sproglige fejl

Ved opmærkning af sproglige fejl vha. attributter, er der mulighed for at anvende både den originale data - hvis man f. eks. er interesseret i fejlene - og at anvende data uden fejl.
####Fejltyper

|Beskrivelse                  | Atribut   | uforkortet navn |
|-----------------------------|-----------|-----------------|
|Ord er forkert i konteksten  |cntxt      |context          |
|Ikke-eksisterende ord        |nonx       |nonexistent      |
|Bokmålsk ord i nynorsk       |bm         |bokmål           |
|Nynorsk ord i bokmål         |nn         |nynorsk          |
|Ordstillingsfejl             |wo         |word order       |
|Manglende ord/fraser         |mw         |missing word     |
|Overflødige ord/fraser       |rw         |redundant word   |


####Korrekturforslag
Korrekturforslaget gives atributtet  - corr (correction) og en af de syv typer af korrektioner:

##Korrektionstyper:

```xml
<sp type="cntxt" corr=""></sp>
<sp type="nonx" corr=""></sp>
<sp type="bm" corr=""></sp>
<sp type="nn" corr=""></sp>
<sp type="wo" corr=""></sp>
<sp type="mw" corr=""/>
<sp type="rw" corr=""></sp>
```
Læg mærke til at opmærkning til _missing_ _word_ er en tomt tag.
###Eksempler:
####Eksempel på kontekstuel stavefejl (cntxt):
#####Original: 
```xml
<tu creationdate="20190312T095802Z" creationid="LF Aligner 3.11"><prop type="Txt::Note">nb-nn</prop>
<tuv xml:lang="NB"><seg>(Bilde 08) BOBLER: Kjersti er særlig glad i bobler, og har en del musserende viner.</seg></tuv>
<tuv xml:lang="NN"><seg>(Bilde 08) BOBLAR: Kjersti er særleg glad i boblar, og har ein del musserande vinar.</seg></tuv> </tu>
```

#####Ændret: 
```xml
<tu creationdate="20190312T095802Z" creationid="Proofed"><prop type="Txt::Note">nb-nn</prop>
<tuv xml:lang="NB"><seg>(Bilde 08) BOBLER: Kjersti er særlig glad i bobler, og har en del musserende viner.</seg></tuv>
<tuv xml:lang="NN"><seg>(Bilde 08) BOBLAR: Kjersti er særleg glad i <sp type="cntxt" corr="bobler">boblar</sp>, og har ein del musserande vinar.</seg></tuv> </tu>
```
####Eksempel på ordstillingsfejl (wo):
#####Original: 
Dårleg oppbygging av setninga:
```xml
<tu creationdate="20190312T095802Z" creationid="LF Aligner 3.11"><prop type="Txt::Note">nb-nn</prop>
<tuv xml:lang="NB"><seg>– Våre dyktige entreprenører i Trøndelag og Møre og Romsdal har mannskapene ute for å gjøre fremkommeligheten bedre, skriver de på Twitter .</seg></tuv>
<tuv xml:lang="NN"><seg>– Dei dugelege entreprenørane våre i Trøndelag og Møre og Romsdal har mannskapa ute for å gjere betre køyreforholda, skriv dei på Twitter .</seg></tuv> </tu>
```

#####Ændret:
Fejl 'gjere betre køyreforholda' kan rettes til enten: 'gjere køyreforholda betre' eller 'betre køyreforholda'. Vi vælger "gjere køyreforholda betre" fordi det er tættere på originalteksten fra bokmål.  
```xml
<tu creationdate="20190312T095802Z" creationid="Proofed"><prop type="Txt::Note">nb-nn</prop>
<tuv xml:lang="NB"><seg>– Våre dyktige entreprenører i Trøndelag og Møre og Romsdal har mannskapene ute for å gjøre fremkommeligheten bedre, skriver de på Twitter .</seg></tuv>
<tuv xml:lang="NN"><seg>– Dei dugelege entreprenørane våre i Trøndelag og Møre og Romsdal har mannskapa ute for å gjere <sp type="wo" corr="køyreforholda betre">betre køyreforholda</sp>, skriv dei på Twitter .</seg></tuv> </tu>
```

####Eksempel på manglende ordfejl (mw):
#####Ændret
```xml
<tu creationdate="20190312T095202Z" creationid="LF Aligner 3.11"><prop type="Txt::Note">nb-nn</prop>
<tuv xml:lang="NB"><seg>Lokalvalget i år var det andre hvor stemmerett for 16- og 17-åringer ble prøvd ut i 20 kommuner.</seg></tuv>
<tuv xml:lang="NN"><seg>Lokalvalet i år var det andre <sp type="mw" corr="der"/> røysterett for 16- og 17-åringar blei prøvd ut i 20 kommunar.</seg></tuv> </tu>
```xml

####Eksempel på fejl med overflødige ord
#####Ændret
<tu creationdate="20190312T094452Z" creationid="LF Aligner 3.11"><prop type="Txt::Note">nb-nn</prop>
<tuv xml:lang="NB"><seg>Det er regjeringen <sp type="rw" corr="">etter lov og politisk</sp> som har ansvaret for å styre norske sykehus.</seg></tuv>
<tuv xml:lang="NN"><seg>Det er regjeringa som har ansvaret for å styre norske sjukehus.</seg></tuv> </tu>

